<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

$savesDir = __DIR__ . '/saves';

// Get POST data
$input = file_get_contents('php://input');
$data = json_decode($input, true);

$slot = (int) ($data['slot'] ?? 0);

if ($slot < 1 || $slot > 10) {
    echo json_encode(['ok' => false, 'error' => 'Nieprawidłowy numer slotu']);
    exit;
}

$filename = $savesDir . '/slot_' . $slot . '.json';

if (!file_exists($filename)) {
    echo json_encode(['ok' => false, 'error' => 'Slot pusty']);
    exit;
}

if (unlink($filename)) {
    echo json_encode(['ok' => true]);
} else {
    echo json_encode(['ok' => false, 'error' => 'Nie udało się usunąć slotu']);
}
