<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

$savesDir = __DIR__ . '/saves';
$slot = (int) ($_GET['slot'] ?? 0);

if ($slot < 1 || $slot > 10) {
    echo json_encode(['ok' => false, 'error' => 'Nieprawidłowy numer slotu']);
    exit;
}

$filename = $savesDir . '/slot_' . $slot . '.json';

if (!file_exists($filename)) {
    echo json_encode(['ok' => false, 'error' => 'Slot pusty', 'empty' => true]);
    exit;
}

$content = file_get_contents($filename);
$saveData = json_decode($content, true);

if (!$saveData || !isset($saveData['data'])) {
    echo json_encode(['ok' => false, 'error' => 'Uszkodzony plik zapisu']);
    exit;
}

echo json_encode([
    'ok' => true,
    'data' => $saveData['data'],
    'slotName' => $saveData['slotName'] ?? 'Slot ' . $slot
]);
