<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

$savesDir = __DIR__ . '/saves';
$lastSaveFile = $savesDir . '/.last_save';

// Ensure saves directory exists
if (!is_dir($savesDir)) {
    mkdir($savesDir, 0777, true);
}

// Get POST data
$input = file_get_contents('php://input');
$data = json_decode($input, true);

if (!$data || !isset($data['slot'])) {
    echo json_encode(['ok' => false, 'error' => 'Brak numeru slotu']);
    exit;
}

$slot = (int) $data['slot'];
if ($slot < 1 || $slot > 10) {
    echo json_encode(['ok' => false, 'error' => 'Nieprawidłowy numer slotu (1-10)']);
    exit;
}

// Rate limit removed for development
// if (file_exists($lastSaveFile)) { ... }

$filename = $savesDir . '/slot_' . $slot . '.json';

// Prepare save data
$saveData = [
    'slot' => $slot,
    'slotName' => $data['slotName'] ?? 'Slot ' . $slot,
    'timestamp' => $now,
    'data' => $data['gameState'] ?? $data
];

// Save to file
if (file_put_contents($filename, json_encode($saveData, JSON_PRETTY_PRINT))) {
    // Update last save time
    file_put_contents($lastSaveFile, $now);

    echo json_encode([
        'ok' => true,
        'slot' => $slot,
        'timestamp' => $now
    ]);
} else {
    echo json_encode(['ok' => false, 'error' => 'Nie udało się zapisać gry']);
}
