<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

$dataFile = __DIR__ . '/../data/skills.json';
$dataDir = dirname($dataFile);

// Create data directory if it doesn't exist
if (!is_dir($dataDir)) {
    mkdir($dataDir, 0755, true);
}

// Load existing skills
$skills = [];
if (file_exists($dataFile)) {
    $content = file_get_contents($dataFile);
    $skills = json_decode($content, true) ?: [];
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = $_POST['name'] ?? '';
    $icon = $_POST['icon'] ?? '⚡';

    if (empty($name)) {
        echo json_encode(['ok' => false, 'error' => 'Name is required']);
        exit;
    }

    // Check for duplicates
    foreach ($skills as $skill) {
        if ($skill['name'] === $name) {
            echo json_encode(['ok' => false, 'error' => 'Skill already exists']);
            exit;
        }
    }

    // Calculate next LP
    $maxLP = 0;
    foreach ($skills as $skill) {
        if (isset($skill['lp']) && $skill['lp'] > $maxLP) {
            $maxLP = $skill['lp'];
        }
    }
    $nextLP = $maxLP + 1;

    // Add new skill
    $newSkill = [
        'name' => $name,
        'icon' => $icon,
        'lp' => $nextLP
    ];

    $skills[] = $newSkill;

    // Save to file
    file_put_contents($dataFile, json_encode($skills, JSON_PRETTY_PRINT));

    echo json_encode(['ok' => true, 'skill' => $newSkill]);
} else {
    echo json_encode(['ok' => false, 'error' => 'Invalid method']);
}
