<?php
header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json');
$itemsFile = __DIR__ . '/items.json';
$locsFile = __DIR__ . '/locations.json';
$skillsFile = __DIR__ . '/skills.json';

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $items = file_exists($itemsFile) ? json_decode(file_get_contents($itemsFile), true) : [];
    $locs = file_exists($locsFile) ? json_decode(file_get_contents($locsFile), true) : [];
    $skills = file_exists($skillsFile) ? json_decode(file_get_contents($skillsFile), true) : [];
    echo json_encode(['items' => $items, 'locations' => $locs, 'skills' => $skills]);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Expect JSON payload or form data with 'data' key
    $data = null;
    if (isset($_POST['data'])) {
        $data = json_decode($_POST['data'], true);
    } else {
        $input = file_get_contents('php://input');
        $data = json_decode($input, true);
    }

    if (!is_array($data)) {
        http_response_code(400);
        echo json_encode(['ok' => false, 'err' => 'Invalid JSON']);
        exit;
    }
    if (isset($data['items'])) {
        file_put_contents($itemsFile, json_encode($data['items'], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
    }
    if (isset($data['locations'])) {
        file_put_contents($locsFile, json_encode($data['locations'], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
    }
    if (isset($data['skills'])) {
        file_put_contents($skillsFile, json_encode($data['skills'], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
    }
    echo json_encode(['ok' => true]);
    exit;
}

http_response_code(405);
echo json_encode(['ok' => false, 'err' => 'Method not allowed']);
?>