<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

$savesDir = __DIR__ . '/saves';

if (!is_dir($savesDir)) {
    mkdir($savesDir, 0777, true);
}

$slots = [];

// Check slots 1-10
for ($i = 1; $i <= 10; $i++) {
    $filename = $savesDir . '/slot_' . $i . '.json';

    if (file_exists($filename)) {
        $content = file_get_contents($filename);
        $data = json_decode($content, true);

        if ($data) {
            $slots[] = [
                'slot' => $i,
                'slotName' => $data['slotName'] ?? 'Slot ' . $i,
                'timestamp' => $data['timestamp'] ?? 0,
                'heroName' => $data['data']['hero']['name'] ?? 'Nieznany',
                'hasData' => true
            ];
        } else {
            $slots[] = [
                'slot' => $i,
                'slotName' => 'Slot ' . $i,
                'timestamp' => 0,
                'heroName' => '',
                'hasData' => false
            ];
        }
    } else {
        $slots[] = [
            'slot' => $i,
            'slotName' => 'Slot ' . $i,
            'timestamp' => 0,
            'heroName' => '',
            'hasData' => false
        ];
    }
}

echo json_encode(['ok' => true, 'slots' => $slots]);
