<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

$savesDir = __DIR__ . '/saves';

// Get POST data
$input = file_get_contents('php://input');
$data = json_decode($input, true);

$slot = (int) ($data['slot'] ?? 0);
$newName = $data['name'] ?? '';

if ($slot < 1 || $slot > 10) {
    echo json_encode(['ok' => false, 'error' => 'Nieprawidłowy numer slotu']);
    exit;
}

if (strlen($newName) > 50) {
    echo json_encode(['ok' => false, 'error' => 'Nazwa zbyt długa (max 50 znaków)']);
    exit;
}

$filename = $savesDir . '/slot_' . $slot . '.json';

if (!file_exists($filename)) {
    echo json_encode(['ok' => false, 'error' => 'Slot pusty']);
    exit;
}

$content = file_get_contents($filename);
$saveData = json_decode($content, true);

if (!$saveData) {
    echo json_encode(['ok' => false, 'error' => 'Uszkodzony plik zapisu']);
    exit;
}

$saveData['slotName'] = $newName ?: 'Slot ' . $slot;

if (file_put_contents($filename, json_encode($saveData, JSON_PRETTY_PRINT))) {
    echo json_encode(['ok' => true, 'slotName' => $saveData['slotName']]);
} else {
    echo json_encode(['ok' => false, 'error' => 'Nie udało się zmienić nazwy']);
}
